
Rem Copyright © 2017-2021, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      wiki_esa_setup.sql - Sample ESA model based on Wikipedia 
Rem
Rem    DESCRIPTION
Rem      This script creates a text policy identical to one used in building
Rem      Explicit Semantic Analysis model from Wikipedia.
Rem      It exhibits the settings used for building the model 
Rem      and shows how to access model data. 
Rem


-- DB configuration: minimum recommended settings
--   sga_max_size=2G
--   sga_target=2G
-- The following commands apply to pre-defined account scott/tiger.
-- As administrator (sysdba): 
--   GRANT CREATE ANY DIRECTORY TO scott;
--   GRANT EXECUTE ON CTXSYS.CTX_DDL TO scott;
--   grant create mining model to scott;
--   CREATE TABLESPACE TBS DATAFILE '<tablespace_file>' SIZE 100M REUSE AUTOEXTEND ON MAXSIZE UNLIMITED;
--   CREATE OR REPLACE DIRECTORY DBDIR AS '<your directory>'; 
--   alter user scott quota unlimited on TBS;
-- In the shell: 
--   copy wiki_model19.0.0.0.0.dmp to your directory
--   impdp scott/tiger dumpfile=wiki_model19.0.0.0.0.dmp directory=DBDIR remap_schema=DMUSER:SCOTT remap_tablespace=TBS_1:TBS

set echo on

-- define text policy matching the model policy
-- !!! scoring will be incorrect if the policy does not match the one used when the model was created
exec ctx_ddl.drop_policy('wiki_txtpol');
exec ctx_ddl.DROP_PREFERENCE( 'wiki_lexer');
exec ctx_ddl.create_preference('wiki_lexer', 'BASIC_LEXER'); 
exec ctx_ddl.set_attribute('wiki_lexer', 'INDEX_STEMS', 'ENGLISH');
exec ctx_ddl.create_policy(policy_name => 'wiki_txtpol', lexer => 'wiki_lexer'); 

