
Rem Copyright (c) 2017-2021 Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      wiki_esa_scoring.sql - Sample ESA scoring for Wikipedia model
Rem
Rem    DESCRIPTION
Rem      This script scores simple text data against the Wikipedia model. 
Rem

-- !!! execute wiki_esa_setup.sql if not done yet

set echo on

-- feature_set scoring examples
col feature_id format a40
col value format 9.999
select s.feature_id, s.value from
  (select feature_set(wiki_model, 10 using *) fset from 
  (SELECT 'bank' AS text FROM dual)) t,
  table(t.fset) s order by s.value desc;

select s.feature_id, s.value from
  (select feature_set(wiki_model, 10 using *) fset from 
  (SELECT 'NFL games' AS text FROM dual)) t,
  table(t.fset) s order by s.value desc;

select s.feature_id, s.value from
     (select feature_set(wiki_model, 10 using *) fset from
     (SELECT 'A group of European-led astronomers has made a photograph of what appears to be a planet orbiting another star. If so, it would be the first confirmed picture of a world beyond our solar system.' 
AS text FROM dual)) t,  table(t.fset) s order by s.value desc; 

select s.feature_id, s.value from
     (select feature_set(wiki_model, 10 using *) fset from
     (SELECT 'Nearly 70 percent of Americans say they are careful about what they eat, and even more say diet is essential to good health, according to a new nationwide health poll in which obesity ranked second among the biggest health concerns.' AS text FROM dual)) t,
   table(t.fset) s order by s.value desc;

select s.feature_id, s.value from
  (select feature_set(wiki_model, 10 using *) fset from 
  (SELECT 'The more things change... Yes, I''m inclined to agree, especially with regards to the historical relationship between stock prices and bond yields. The two have generally traded together, rising during periods of economic growth and falling during periods of contraction. Consider the period from 1998 through 2010, during which the U.S. economy experienced two expansions as well as two recessions: Then central banks came to the rescue. Fed Chairman Ben Bernanke led from Washington with the help of the bank''s current $3.6T balance sheet. He''s accompanied by Mario Draghi at the European Central Bank and an equally forthright Shinzo Abe in Japan. Their coordinated monetary expansion has provided all the sugar needed for an equities moonshot, while they vowed to hold global borrowing costs at record lows' AS text FROM dual)) t,
table(t.fset) s order by s.value desc;


-- feature_compare scoring examples
col comp format 9.999
select 1-feature_compare(wiki_model using 'street' as text and using 'avenue' as text) comp from dual;

select 1-feature_compare(wiki_model using 'street' as text and using 'farm' as text) comp from dual;


select 1-feature_compare(wiki_model using 
'Senior members of the Saudi royal family paid at least $560 million to Osama bin Laden terror group and the Taliban for an agreement his forces would not attack targets in Saudi Arabia, according to court documents. The papers, filed in a $US3000 billion ($5500 billion) lawsuit in the US, allege the deal was made after two secret meetings between Saudi royals and leaders of al-Qa ida, including bin Laden. The money enabled al-Qa ida to fund training camps in Afghanistan later attended by the September 11 hijackers. The disclosures will increase tensions between the US and Saudi Arabia.' as text
and using 
'The Saudi Interior Ministry on Sunday confirmed it is holding a 21-year-old Saudi man the FBI is seeking for alleged links to the Sept. 11 hijackers. Authorities are interrogating Saud Abdulaziz Saud al-Rasheed "and if it is proven that he was connected to terrorism, he will be referred to the sharia (Islamic) court," the official Saudi Press Agency quoted an unidentified ministry official as saying.' as text) comp from dual;

select 1-feature_compare(wiki_model using 
'Senior members of the Saudi royal family paid at least $560 million to Osama bin Laden terror group and the Taliban for an agreement his forces would not attack targets in Saudi Arabia, according to court documents. The papers, filed in a $US3000 billion ($5500 billion) lawsuit in the US, allege the deal was made after two secret meetings between Saudi royals and leaders of al-Qa ida, including bin Laden. The money enabled al-Qa ida to fund training camps in Afghanistan later attended by the September 11 hijackers. The disclosures will increase tensions between the US and Saudi Arabia.' as text
and using 
'Russia defended itself against U.S. criticism of its economic ties with countries like Iraq, saying attempts to mix business and ideology were misguided. "Mixing ideology with economic ties, which was characteristic of the Cold War that Russia and the United States worked to end, is a thing of the past," Russian Foreign Ministry spokesman Boris Malakhov said Saturday, reacting to U.S. Defense Secretary Donald Rumsfeld statement that Moscow economic relationships with such countries sends a negative signal.' as text) comp from dual;


SELECT 1-FEATURE_COMPARE(wiki_model USING 'There are several PGA tour golfers from South Africa' text AND USING 'Nick Price won the 2002 Mastercard Colonial Open' text) comp FROM DUAL;

SELECT 1-FEATURE_COMPARE(wiki_model USING 'There are several PGA tour golfers from South Africa' text AND USING 'John Elway played quarterback for the Denver Broncos' text) comp FROM DUAL;


